import 'package:flutter/cupertino.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

class MySubListViewPublic extends StatelessWidget {
  final bool canLoadMore; //是否允许上拉
  final ItemBuilder itemBuilder;
  final MyListController? controller;
  final bool firstRefresh;
  final String? emptyText;
  // 数据为空时，缺省图
  final String? emptyImg;
  // (page, pageSize,_requestSuccess,_requestError){}
  final RequestDataCallback requestData;
  // 一页的数量，默认为10
  final int pageSize;
  // padding属性使用时注意会破坏原有的SafeArea，需要自行计算bottom大小
  final EdgeInsetsGeometry? padding;
  final double? itemExtent;
  final Function? onRefresh;

  const MySubListViewPublic({
    super.key,
    required this.itemBuilder,
    required this.requestData,
    this.pageSize = 10,
    this.padding,
    this.itemExtent,
    this.controller,
    this.onRefresh,
    this.canLoadMore = true,
    this.firstRefresh = true,
    this.emptyText,
    this.emptyImg,
  });

  @override
  Widget build(BuildContext context) {
    return MyListViewPublic(
      itemBuilder: itemBuilder,
      requestData: requestData,
      pageSize: pageSize,
      padding: padding,
      itemExtent: itemExtent,
      controller: controller,
      onRefresh: onRefresh,
      canLoadMore: canLoadMore,
      firstRefresh: firstRefresh,
      emptyText: emptyText,
      emptyImg: 'default_drawing_1',
      errorImg: 'default_drawing_5',
    );
  }
}