import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

/// 头像widget
class HeadWidget extends StatelessWidget {
  final String? domain;
  final String? headUrl;
  final double? width;
  final double? height;

  const HeadWidget(
      {super.key, this.domain, this.headUrl, this.width, this.height});

  @override
  Widget build(BuildContext context) {
    return headUrl.isNullOrEmpty()
        ? ImageWidget.loadAssetImage("head",
            width: width, height: height)
        : ImageWidget.loadNetImage(
            headUrl,
            domain: domain,
            width: width,
            height: height,
            maxWidth: width != null ? (3 * width!).toInt() : null,
            maxHeight: height != null ? (3 * height!).toInt() : null,
            type: ImageTransformerType.circle,
          );
  }
}
