import 'package:flutter/material.dart';
import 'package:flutter_clx_base/common/extension.dart';
import 'package:fluttertoast/fluttertoast.dart';

class ToastUtil {
  static void showToast(String? txt,
      {ToastDuration toastDuration = ToastDuration.short}) {
    if (txt.isNullOrEmpty()) {
      txt = "信息异常";
    }
    Fluttertoast.showToast(
        msg: txt ?? "",
        toastLength: toastDuration == ToastDuration.long
            ? Toast.LENGTH_LONG
            : Toast.LENGTH_SHORT,
        gravity: ToastGravity.CENTER,
        // timeInSecForIos: 1,
        backgroundColor: const Color(0xB3000000),
        textColor: Colors.white,
        fontSize: 17.0);
  }

  static void showLongToast(String? txt) {
    showToast(txt, toastDuration: ToastDuration.long);
  }
}

enum ToastDuration {
  /// Show Short toast for 1 sec
  short,

  /// Show Long toast for 5 sec
  long
}
