import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

bool isNullOrEmpty(String? txt) {
  return txt == null || txt.isEmpty;
}

///判断文字是否为空
String txtIsNull(String? txt, {String nullTxt = "-"}) {
  if (txt == null || txt == "") {
    return nullTxt;
  } else {
    return txt;
  }
}

String txtIsNullWithTitle(String? txt, String title, {String nullTxt = "-"}) {
  if (txt == null || txt == "") {
    return nullTxt;
  } else {
    return "$title: $txt";
  }
}

///设置文字长度
String txtLength(String? txt, {int? length, nullTxt = ""}) {
  if (txt == null || txt == "") {
    return nullTxt;
  } else {
    if (length != null && txt.length > length) {
      return "${txt.substring(0, length)}...";
    }
    return txt;
  }
}

//时间去除.0
String? rightTime(String? time) {
  String? rightTime = time;
  if (time != null && time != "" && time.contains(".")) {
    rightTime = time.split(".")[0];
  }
  return rightTime;
}

//获取当前时间
String? getNowTime() {
  return rightTime(DateTime.now().toString());
}

//获取输入框内的信息
String getControllerString(TextEditingController? controller) {
  return controller?.value.text.toString().trim() ?? "";
}

//获取输入框内的文字长度
int getControllerStringLength(TextEditingController controller) {
  return getControllerString(controller).length;
}

bool checkEasyPwd(String input, String phone) {
  //1：不能出现连续的字母或者数字
  var allMatchLength = input.length - 1; // 匹配全部
  var preMatchLength = input.length - 2; // 匹配N-1位
  RegExp allSameChar = RegExp("([0-9a-zA-Z])\\1{$allMatchLength}"); // 匹配全为连续字符
  RegExp preSameChar =
      RegExp("([0-9a-zA-Z])\\1{$preMatchLength}"); // 匹配n-1位位连续字符
  //2：不能出现顺子（123456或654321一类） 连续的数字
  // allSuccessiveNum 顺子
  // startCharSuccessiveNum  第一位字母  后面顺子
  // endCharSuccessiveNum    最后一位字母  前面顺子
  RegExp allSuccessiveNum = RegExp(
      "(?:0(?=1)|1(?=2)|2(?=3)|3(?=4)|4(?=5)|5(?=6)|6(?=7)|7(?=8)|8(?=9)|9(?=0)){$allMatchLength}\\d|(?:9(?=8)|8(?=7)|7(?=6)|6(?=5)|5(?=4)|4(?=3)|3(?=2)|2(?=1)|1(?=0)){$allMatchLength}\\d");
  RegExp startCharSuccessiveNum = RegExp(
      "[A-Za-z](?:0(?=1)|1(?=2)|2(?=3)|3(?=4)|4(?=5)|5(?=6)|6(?=7)|7(?=8)|8(?=9)){$preMatchLength}\\d|[A-Za-z](?:9(?=8)|8(?=7)|7(?=6)|6(?=5)|5(?=4)|4(?=3)|3(?=2)|2(?=1)|1(?=0)){$preMatchLength}\\d");
  RegExp endCharSuccessiveNum = RegExp(
      "((?:0(?=1)|1(?=2)|2(?=3)|3(?=4)|4(?=5)|5(?=6)|6(?=7)|7(?=8)|8(?=9)){$preMatchLength}\\d)[A-Za-z]|((?:9(?=8)|8(?=7)|7(?=6)|6(?=5)|5(?=4)|4(?=3)|3(?=2)|2(?=1)|1(?=0)){$preMatchLength}\\d)[A-Za-z]");

  // print('----- allSameChar: $allSameChar');
  // print('----- preSameChar: $preSameChar');
  // print('----- allSuccessiveNum: $allSuccessiveNum');
  // print('----- startCharSuccessiveNum: $startCharSuccessiveNum');
  // print('----- endCharSuccessiveNum: $endCharSuccessiveNum');
  // print('----- allSameChar: $input ${allSameChar.hasMatch(input)}');
  // print('----- preSameChar: $input ${preSameChar.hasMatch(input)}');
  // print('----- allSuccessiveNum: $input ${allSuccessiveNum.hasMatch(input)}');
  // print('----- startCharSuccessiveNum: $input ${startCharSuccessiveNum.hasMatch(input)}');
  // print('----- endCharSuccessiveNum: $input ${endCharSuccessiveNum.hasMatch(input)}');
  return allSameChar.hasMatch(input) ||
      preSameChar.hasMatch(input) ||
      allSuccessiveNum.hasMatch(input) ||
      startCharSuccessiveNum.hasMatch(input) ||
      endCharSuccessiveNum.hasMatch(input) ||
      phone.contains(input);
}

/// 密码校验规则
///密码长度8-12位
///密码由数字及大小写英文字母组成
///密码中需包含至少1个大写字母+1个小写字母+1个数字
bool checkPwdRule(String pwd){
  RegExp regExp = RegExp("(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])[A-Za-z0-9]{8,12}");
  return regExp.hasMatch(pwd);
}

/// 密码校验规则
///密码长度8-12位
///密码由数字及大小写英文字母组成
///密码中需包含至少1个大写字母或1个小写字母+1个数字
bool checkPwdRuleDriver(String pwd){
  RegExp regExp = RegExp("(?=.*[A-Za-z])(?=.*[0-9])[A-Za-z0-9]{8,12}");
  return regExp.hasMatch(pwd);
}

/// 禁止输入表情
String regexEmoji() {
  return "[^\\u0020-\\u007E\\u00A0-\\u00BE\\u2E80-\\uA4CF\\uF900-\\uFAFF\\uFE30-\\uFE4F\\uFF00-\\uFFEF\\u0080-\\u009F\\u2000-\\u201f\r\n]";
}

/// 隐藏手机信息
String hidePhone(String? phone) {
  return !phone.isNullOrEmpty()
      ? phone!.replaceFirst(RegExp(r'\d{4}'), '****', 3)
      : "";
}

/// 判断是否是手机
bool isMobile(String? phone) {
  RegExp exp = RegExp(r'^1[0-9]{10}');
  bool matched = exp.hasMatch(phone!);
  return matched;
}

/// 姓名脱敏
String hideName(String? name) {
  if (name.isNullOrEmpty()) {
    return "";
  }
  if (name!.length == 1) {
    return name;
  }
  if (name.length == 2) {
    return name.replaceRange(0, 1, "*");
  }
  if (name.length > 2) {
    return name.replaceRange(1, name.length - 1, "*");
  }
  return "";
}

/// 隐藏银行卡号
String hideBankCard(String? bankCard) {
  return !bankCard.isNullOrEmpty()
      ? bankCard!.replaceRange(0,
      bankCard.length < 4 ? 0 : bankCard.length - 4, '**** **** **** ***')
      : "";
}