import 'package:easy_refresh/easy_paging.dart';
import 'package:easy_refresh/easy_refresh.dart';
import 'package:flutter/material.dart';
import 'package:flutter_spinkit/flutter_spinkit.dart';

class CustomPagingList extends EasyPaging<List<String>, String> {

  
    const CustomPagingList({
    Key? key,
    super.callLoadOverOffset,
    super.callRefreshOverOffset,
    super.clipBehavior,
    super.controller,
    super.fit,
    super.frictionFactor,
    super.notLoadFooter,
    super.notRefreshHeader,
    super.refreshOnStart = true,
    super.resetAfterRefresh,
    super.simultaneously,
    super.spring,
    super.useDefaultPhysics,
    super.itemBuilder,
    super.refreshOnStartWidgetBuilder,
    super.emptyWidgetBuilder,
  }) : super(key: key);

  
  @override
  EasyPagingState<List<String>, String> createState() => CustomPagingListState();



}


class CustomPagingListState extends EasyPagingState<List<String>, String> {
  @override
  int get count => data?.length ?? 0;

  @override
  String getItem(int index) {
    return data![index];
  }

  @override
  Header buildHeader() {
    return const DeliveryHeader();
  }

  @override
  int? page;

  @override
  int? total;

  @override
  int? totalPage;

  @override
  Widget? buildRefreshOnStartWidget() {
    return Container(
      padding: const EdgeInsets.only(bottom: 100),
      width: double.infinity,
      height: double.infinity,
      alignment: Alignment.center,
      child: SpinKitFadingCube(
        size: 24,
        color: Theme.of(context).colorScheme.primary,
      ),
    );
  }

  @override
  Widget? buildEmptyWidget() {
    return Container(
      padding: const EdgeInsets.only(bottom: 120),
      width: double.infinity,
      height: double.infinity,
      alignment: Alignment.center,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          SpinKitSpinningLines(
            size: 80,
            color: Theme.of(context).colorScheme.primary,
          ),
          const SizedBox(height: 16),
          const Text('No Data'),
        ],
      ),
    );
  }



  @override
  Future onRefresh() async {
  
  }

  @override
  Future onLoad() async {

  }
}



