import 'package:flutter_clx_base/utils/log_utils.dart';
import 'package:get/get.dart';


S? findOtherLogic<S>() {
  if (Get.isRegistered<S>()) {
    return Get.find<S>();
  }
  return null;
}

// 任意类型转String
String getTXTString(dynamic data) {
  if (data is String) {
    return data;
  } else if (data is int) {
    return data.toString();
  } else if (data is double) {
    return data.toString();
  } else if (data is bool) {
    return data.toString();
  } else {
    return "";
  }
}

// 格式化小数两位
String formatDouble(number, {nullTxt = "-"}) {
  if (number == null || number == "") {
    return nullTxt;
  }
  double num;
  try {
    num = double.parse(number.toString());
  } catch (e) {
    loggerNoStack.d("转换异常:$e");
    return nullTxt;
  }
  if ((num.toString().length - num.toString().lastIndexOf(".") - 1) < 2) {
    //小数点后有几位小数
    return num.toStringAsFixed(2)
        .substring(0, num.toString().lastIndexOf(".") + 2 + 1)
        .toString();
  } else {
    return num.toString()
        .substring(0, num.toString().lastIndexOf(".") + 2 + 1)
        .toString();
  }
}

// double格式化 默认 0.00
String formatDoubleZero(number) {
  return formatDouble(number, nullTxt: "0.00");
}

// int 转换 默认0
String formatInt(number, {nullTxt = "-"}) {
  if (number == null || number == "") {
    return nullTxt;
  }
  int num;
  try {
    num = int.parse(number.toString());
  } catch (e) {
    loggerNoStack.i("转换异常:$e");
    return nullTxt;
  }
  return num.toString();
}

// int格式化 默认 0
String formatIntZero(number) {
  return formatInt(number, nullTxt: "0");
}
