import 'dart:io';

import 'package:device_info_plus/device_info_plus.dart';
import 'package:flutter/services.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:unique_identifier/unique_identifier.dart';

class DeviceUtils {

  //uuid
  static getDeviceSerial() async {
    if (Platform.isAndroid) {
      String? identifier = "Unknown";
      try {
        identifier = await UniqueIdentifier.serial ?? "Unknown";
      } on PlatformException {
        identifier = "Unknown";
      }
      return identifier;
    } else if (Platform.isIOS) {
      String? identifier = "Unknown";
      try {
        // TODO: 2023/7/6 iOS获取序列号
        // identifier = await VersionUtils.getUuidForKeychain();
      } on PlatformException {
        identifier = "Unknown";
      }
      return identifier;
    }
  }

  static getVersionName() async {
    PackageInfo packageInfo = await PackageInfo.fromPlatform();
    return packageInfo.version;
  }

  static getVersionCode() async {
    PackageInfo packageInfo = await PackageInfo.fromPlatform();
    return packageInfo.buildNumber.toInt();
  }

  static getDeviceModel() async {
    DeviceInfoPlugin deviceInfo = DeviceInfoPlugin();
    if (Platform.isAndroid) {
      AndroidDeviceInfo androidInfo = await deviceInfo.androidInfo;
      return androidInfo.model;
    } else {
      IosDeviceInfo iosInfo = await deviceInfo.iosInfo;
      return iosInfo.name;
    }
  }

}
