import 'package:flutter/material.dart';
import 'package:flutter_clx_base/api/dio_utils.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class DioWidgetTest extends StatefulWidget {
  const DioWidgetTest({super.key});

  @override
  State<DioWidgetTest> createState() => _DioWidgetTestState();
}

class _DioWidgetTestState extends State<DioWidgetTest> {
  static const String getSystemVersionByNumber =
      '/user-service/system/version/getSystemVersionByNumber';
  String _result = '';

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      title: 'DioWidget',
      children: [
        Text(_result),
        TextButton(
            onPressed: () {
              DioUtils.instance.request(
                requestUrl: getSystemVersionByNumber,
                method: Method.get,
                queryParameters: {
                  'versionNumber': 20,
                  'productNo': 1,
                },
                successCallback: (res) {
                  setState(() {
                    _result = res.toString();
                  });
                },
                errorCallback: (code, msg) {
                  setState(() {
                    _result = msg!;
                  });
                },
              );
            },
            child: const Text('dio请求')),
      ],
    );
  }
}
