import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/utils/string_util.dart';

class SearchAppBar extends StatefulWidget implements PreferredSizeWidget {
  final Function? onCallback;
  final String? hintText;
  final Widget? leading;
  final Color? backgroundColor;
  final Color? foregroundColor;
  final bool primary;
  final Color? searchBackgroundColor;
  final Color? inputTextColor;
  final Color? hintTextColor;
  final Color? rightTextColor;
  final Color? searchIconColor;
  final double? searchIconSize;
  final Function? onFocusListener;
  final String? rightText;
  final Function? onRightBtnCallback;
  final Widget? leftWidget;
  final EdgeInsetsGeometry? margin;
  final bool automaticallyImplyLeading;
  final TextEditingController? textEditingController;
  final double? leadingWidth;
  final double? searchBgRadius; // 搜索背景圆角
  final int? maxLength; // 最大个数
  final double? elevation; // 阴影

  const SearchAppBar({
    Key? key,
    this.onCallback,
    this.hintText = "请输入搜索内容",
    this.leading,
    this.backgroundColor,
    this.foregroundColor,
    this.primary = true,
    this.searchBackgroundColor,
    this.inputTextColor,
    this.hintTextColor,
    this.rightTextColor,
    this.onFocusListener,
    this.rightText,
    this.onRightBtnCallback,
    this.searchIconColor,
    this.searchIconSize,
    this.leftWidget,
    this.margin,
    this.automaticallyImplyLeading = true,
    this.textEditingController,
    this.leadingWidth,
    this.searchBgRadius,
    this.maxLength,
    this.elevation,
  }) : super(key: key);

  @override
  State<SearchAppBar> createState() => _SearchAppBarState();

  @override
  Size get preferredSize => const Size(double.infinity, 55.0);
}

class _SearchAppBarState extends State<SearchAppBar> {
  late TextEditingController _searchInfoController;
  final _searchFocusNode = FocusNode();

  @override
  void initState() {
    _searchFocusNode.addListener(() {
      if (widget.onFocusListener != null) {
        widget.onFocusListener!(_searchFocusNode.hasFocus);
      }
    });
    _searchInfoController = widget.textEditingController ?? TextEditingController();
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return AppBar(
      backgroundColor: widget.backgroundColor,
      foregroundColor: widget.foregroundColor,
      titleSpacing: 0.0,
      primary: widget.primary,
      leading: widget.leading,
      leadingWidth: widget.leadingWidth,
      automaticallyImplyLeading: widget.automaticallyImplyLeading,
      elevation: widget.elevation,
      title: Row(
        children: <Widget>[
          Expanded(
            child: Container(
              margin: widget.margin,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.all(
                    Radius.circular(widget.searchBgRadius ?? 20.0)),
                color:
                    widget.searchBackgroundColor ?? const Color(0xFFEEEEEE),
              ),
              child: Row(
                children: <Widget>[
                  hGap10,
                  widget.leftWidget ??
                      Icon(
                        Icons.search,
                        color: widget.searchIconColor ?? Colors.grey.shade300,
                        size: widget.searchIconSize,
                      ),
                  hGap5,
                  Expanded(
                    child: TextField(
                      maxLines: 1,
                      maxLength: widget.maxLength,
                      focusNode: _searchFocusNode,
                      inputFormatters: [
                        FilteringTextInputFormatter.deny(RegExp(regexEmoji())),
                      ],
                      style: TextStyle(
                          fontSize: 14,
                          color: widget.inputTextColor ??
                              const Color(0xFF000000)),
                      textInputAction: TextInputAction.search,
                      controller: _searchInfoController,
                      onSubmitted: (value) => _search(),
                      decoration: InputDecoration(
                        contentPadding: const EdgeInsets.symmetric(
                            horizontal: 0.0, vertical: 8.0),
                        isDense: true,
                        counterText: "",
                        hintText: widget.hintText,
                        hintStyle: TextStyle(
                            fontSize: 14.0,
                            color: widget.hintTextColor ??
                                const Color(0xFF999999)),
                        border: InputBorder.none, //去掉下划线
                        //hintStyle: TextStyles.textGrayC14
                      ),
                    ),
                  ),
                  hGap5,
                ],
              ),
            ),
          ),
          widget.rightText.isNullOrEmpty()
              ? const SizedBox(width: 15.0)
              : InkWell(
                  onTap: () {
                    widget.onRightBtnCallback != null
                        ? widget.onRightBtnCallback?.call()
                        : _search();
                  },
                  child: Container(
                    width: 60.0,
                    height: 50.0,
                    alignment: Alignment.center,
                    child: Text(
                      widget.rightText ?? "搜索",
                      style: TextStyle(
                          color: widget.rightTextColor ??
                              const Color(0xFFFFFFFF),
                          fontSize: 14.0),
                    ),
                  ),
                )
        ],
      ),
    );
  }

  /// 校验
  // bool _checkInfo() {
  //   if (isNullOrEmpty(getControllerString(_searchInfoController))) {
  //     ToastUtil.showToast("请输入搜索内容");
  //     return false;
  //   }
  //   return true;
  // }

  /// 搜索
  void _search() {
    // if (_checkInfo()) {
      KeyBoardUtils.hideKeyboard();
      if (widget.onCallback != null) {
        widget.onCallback!(getControllerString(_searchInfoController));
      }
    // }
  }
}
