import 'package:flutter/material.dart';

class MyPageAppBar extends StatelessWidget implements PreferredSizeWidget {
  final String? title; // 标题
  final Color? backgroundColor; // 背景颜色
  final Color? foregroundColor; // 前景颜色
  final bool showBack; // 是否展示返回箭头
  final bool primary;
  final List<Widget>? actions; // 右侧widget
  final Widget? leading; // 左侧widget
  final double? elevation; // 阴影
  final Widget? titleWidget; // 自定义标题widget
  final double? titleSpacing; // 标题横向padding

  const MyPageAppBar({
    Key? key,
    this.title,
    this.backgroundColor,
    this.foregroundColor,
    this.showBack = true,
    this.primary = true,
    this.actions,
    this.leading,
    this.elevation = 0,
    this.titleWidget,
    this.titleSpacing,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return AppBar(
      key: key,
      centerTitle: true,
      titleSpacing: titleSpacing,
      title: titleWidget ??
          Text(title ?? "", style: TextStyle(color: foregroundColor)),
      backgroundColor: backgroundColor,
      foregroundColor: foregroundColor,
      primary: primary,
      actions: actions,
      leading: !showBack ? null : leading,
      elevation: elevation,
      // If false and [leading] is null, leading space is given to [title].
      automaticallyImplyLeading: showBack,
    );
  }

  @override
  Size get preferredSize => const Size(double.infinity, 55.0);
}
