import 'package:flutter_clx_base/api/base_dio.dart';
import 'dio_utils.dart';

class NetUtils {
  static void get(url, queryParameters, successCallback, errorCallback) {
    DioUtils.instance.request(
        requestUrl: url,
        queryParameters: queryParameters,
        method: Method.get,
        successCallback: successCallback,
        errorCallback: errorCallback);
  }

  static void post(url, data, successCallback, errorCallback) {
    DioUtils.instance.request(
        requestUrl: url,
        method: Method.post,
        data: data,
        successCallback: successCallback,
        errorCallback: errorCallback);
  }
}
