import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/base_list_widget.dart';
// import 'package:rive/rive.dart';

class BaseListWidgetTest extends StatefulWidget {
  const BaseListWidgetTest({super.key});

  @override
  State<BaseListWidgetTest> createState() => _BaseListWidgetTestState();
}

class _BaseListWidgetTestState extends State<BaseListWidgetTest> {
  @override
  Widget build(BuildContext context) {
    final themeData = Theme.of(context);
    return MyScaffold(
      title: 'BaseListWidget',
      body: BaseListWidget(
        requestData: (page, pageSize, success, error) async {
          await Future.delayed(const Duration(seconds: 5));
          if (page == 1) {
            success([
              '1',
              '2',
              '3',
              '4',
              '5',
              '6',
              '7',
              '8',
              '9',
              '10',
            ]);
          } else {
            success([
              '11',
              '12',
              '13',
              '14',
              '15',
              '16',
              '17',
              '18',
              '19',
              '20',
            ]);
          }
        },
        pageSize: 10,
        itemBuilder: (BuildContext context, int index, item) {
          return Container(
            decoration: BoxDecoration(
              border: Border(
                bottom: BorderSide(
                  color: Colors.grey.withOpacity(0.5),
                  width: 0.5,
                ),
              ),
            ),
            alignment: Alignment.center,
            height: 100,
            child: Text(item.toString()),
          );
        },
        header: TaurusHeader(
          skyColor: themeData.colorScheme.primary,
        ),
        footer: ClassicFooter(
          dragText: 'Pull to load'.tr,
          armedText: 'Release ready'.tr,
          readyText: 'Loading...'.tr,
          processingText: 'Loading...'.tr,
          processedText: 'Succeeded'.tr,
          noMoreText: 'No more'.tr,
          failedText: 'Failed'.tr,
          messageText: 'Last updated at %T'.tr,
        ),
        startLoadWidget: Container(
          alignment: Alignment.center,
          width: double.infinity,
          height: 300,
          // child: const RiveAnimation.asset(
          //   'assets/rive/highway-truck.riv',
          //   fit: BoxFit.cover,
          // ),
        ),
      ),
    );
  }
}
