import 'package:flutter/material.dart';
import 'package:flutter_clx_base/api/base_dio.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base_example/sample/dio/dio_utils.dart';

class DioWidgetTest extends StatefulWidget {
  const DioWidgetTest({super.key});

  @override
  State<DioWidgetTest> createState() => _DioWidgetTestState();
}

class _DioWidgetTestState extends State<DioWidgetTest> {
  static const String getSystemVersionByNumber =
      '/clx-performance/lco/app/driver/orderChild/getGoingLatestOrderChild';
  String _result = '';

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      title: 'DioWidget',
      children: [
        Text(_result),
        TextButton(
            onPressed: () async {
              debugPrint("=====11111");
              DioUtils.instance.request(
                requestUrl: getSystemVersionByNumber,
                method: Method.get,
                queryParameters: {
                  'versionNumber': 20,
                  'productNo': 1,
                },
                successCallback: (res) {
                  debugPrint("=====successCallback");
                  setState(() {
                    _result = '0000';
                  });
                },
                errorCallback: (code, msg) {
                  debugPrint("=====errorCallback");
                  setState(() {
                    _result = "code: $code meg = $msg";
                  });
                },
              );
              debugPrint("=====22222");
            },
            child: const Text('dio请求')),
        TextButton(
            onPressed: () async {
              debugPrint("=====11111");
              var result = await DioUtils.instance.requestSync(
                  requestUrl: getSystemVersionByNumber,
                  method: Method.get,
                  queryParameters: {
                    'versionNumber': 20,
                    'productNo': 1,
                  });
              debugPrint("=====22222 result = $result");
            },
            child: const Text('dio请求 sync')),
      ],
    );
  }
}
