import 'package:easy_refresh/easy_refresh.dart';
import 'package:flutter/material.dart';
import 'package:flutter_spinkit/flutter_spinkit.dart';

class BaseListWidget extends StatefulWidget {
  final RequestDataCallback requestData;
  final int pageSize;
  final ItemBuilder itemBuilder;

  const BaseListWidget({
    Key? key,
    required this.requestData,
    required this.pageSize,
    required this.itemBuilder,
  }) : super(key: key);

  @override
  State<BaseListWidget> createState() => _BaseListWidgetState();
}

class _BaseListWidgetState extends State<BaseListWidget> {
  late EasyRefreshController _controller;
  final List<dynamic> _dataList = [];
  int _page = 1;
  int _count = 0;
  @override
  void initState() {
    super.initState();
    _controller = EasyRefreshController(
      controlFinishRefresh: true,
      controlFinishLoad: true,
    );
  }

  @override
  Widget build(BuildContext context) {
    return EasyRefresh(
      controller: _controller,
      refreshOnStart: true,
      refreshOnStartHeader: BuilderHeader(
        triggerOffset: 70,
        clamping: true,
        position: IndicatorPosition.above,
        processedDuration: Duration.zero,
        builder: (ctx, state) {
          if (state.mode == IndicatorMode.inactive ||
              state.mode == IndicatorMode.done) {
            return const SizedBox();
          }
          return Container(
            padding: const EdgeInsets.only(bottom: 100),
            width: double.infinity,
            height: state.viewportDimension,
            alignment: Alignment.center,
            child: SpinKitFadingCube(
              size: 24,
              color: Theme.of(context).primaryColor,
            ),
          );
        },
      ),
      onRefresh: _onRefresh,
      onLoad: _onLoad,
      child: CustomScrollView(
        slivers: [
          SliverList(
            delegate: SliverChildBuilderDelegate(
              (context, index) {
                return widget.itemBuilder(context, index, _dataList[index]);
              },
              childCount: _count,
            ),
          ),
        ],
      ),
    );
  }

  Future<void> _onRefresh() async {
    _page = 1;
    await widget.requestData(
        _page, widget.pageSize, _requestSuccess, _requestError);
  }

  Future<void> _onLoad() async {
    _page++;
    await widget.requestData(
        _page, widget.pageSize, _requestSuccess, _requestError);
  }

  void _requestSuccess(List? result) {
    if (!mounted) {
      return;
    }
    result ??= [];
    if (_page == 1) {
      setState(() {
        _dataList.clear();
        _dataList.addAll(result!);
        _count = _dataList.length;
      });
      _controller.finishRefresh();
      _controller.resetFooter();
    } else {
      setState(() {
        _dataList.addAll(result!);
        _count = _dataList.length;
      });
      _controller.finishLoad(result.length <= widget.pageSize
          ? IndicatorResult.noMore
          : IndicatorResult.success);
    }
  }

  void _requestError(r, s) {
    if (!mounted) {
      return;
    }
  }
}

typedef RefreshCallback = Future<void> Function();
typedef LoadMoreCallback = Future<void> Function();
typedef SuccessCallback = Function(List list);
typedef ErrorCallback = Function(int code, String msg);
typedef RequestDataCallback = Function(
    int page, int pageSize, SuccessCallback success, ErrorCallback error);
typedef ItemBuilder = Function(BuildContext context, int index, dynamic item);
