import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/base_list_widget.dart';

class BaseListWidgetTest extends StatefulWidget {
  const BaseListWidgetTest({super.key});

  @override
  State<BaseListWidgetTest> createState() => _BaseListWidgetTestState();
}

class _BaseListWidgetTestState extends State<BaseListWidgetTest> {
  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      title: 'BaseListWidget',
      body: BaseListWidget(
        requestData: (page, pageSize, success, error) async {
          await Future.delayed(const Duration(seconds: 2));
          if (page == 1) {
            success([
              '1',
              '2',
              '3',
              '4',
              '5',
              '6',
              '7',
              '8',
              '9',
              '10',
            ]);
          } else {
            success([
              '11',
              '12',
              '13',
              '14',
              '15',
              '16',
              '17',
              '18',
              '19',
              '20',
            ]);
          }
        },
        pageSize: 10,
        itemBuilder: (BuildContext context, int index, item) {
          return Container(
            decoration: BoxDecoration(
              border: Border(
                bottom: BorderSide(
                  color: Colors.grey.withOpacity(0.5),
                  width: 0.5,
                ),
              ),
            ),
            alignment: Alignment.center,
            height: 100,
            child: Text(item.toString()),
          );
        },
      ),
    );
  }
}
