import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

/// 通用dialog
class NormalDialog extends StatelessWidget {
  const NormalDialog({
    super.key,
    this.onCancel,
    this.onConfirm,
    this.title = '提示',
    this.content,
    this.contentWidget,
    this.cancelBtnText = '取消',
    this.confirmBtnText = '确定',
  });

  final Function? onCancel;
  final Function? onConfirm;
  final String? cancelBtnText;
  final String confirmBtnText;
  final String? title;
  final String? content;
  final Widget? contentWidget;

  @override
  Widget build(BuildContext context) {
    return Dialog(
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8)),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Column(
            children: [
              Offstage(
                  offstage: title == null, child: const SizedBox(height: 10)),
              Text(title ?? '',
                  style: const TextStyle(
                      fontSize: 16,
                      fontWeight: FontWeight.w500,
                      color: Color(0xFF101827))),
              const SizedBox(height: 10),
              contentWidget == null
                  ? Padding(
                      padding: const EdgeInsets.only(left: 16, right: 16),
                      child: Text(
                        content ?? '',
                        style: const TextStyle(
                            fontSize: 14,
                            color: Color(0xFF86909C),
                            height: 1.5),
                        textAlign: TextAlign.center,
                      ),
                    )
                  : contentWidget!,
              const SizedBox(height: 20.0),
              Container(height: 1, color: const Color(0xffE5E6EB)),
            ],
          ),
          SizedBox(
            height: 45,
            child: Row(
              children: [
                cancelBtnText != null
                    ? Expanded(
                        child: TextButton(
                          child: Text(cancelBtnText ?? '',
                              style: const TextStyle(
                                  color: Color(0xFF101827), fontSize: 16)),
                          onPressed: () {
                            Get.back();
                            onCancel?.call();
                          },
                        ),
                      )
                    : const SizedBox(),
                cancelBtnText != null
                    ? Container(
                        width: 1,
                        color: const Color(0xffE5E6EB),
                      )
                    : const SizedBox(),
                Expanded(
                  child: TextButton(
                    child: Text(
                      confirmBtnText,
                      style: const TextStyle(fontSize: 16),
                    ),
                    onPressed: () {
                      Get.back();
                      onConfirm?.call();
                    },
                  ),
                ),
              ],
            ),
          )
        ],
      ),
    );
  }
}
