import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class SnackBarUtil {
  static void show(String? txt) {
    Get.snackbar("", "",
        titleText: Text(
          txt ?? "",
          style: const TextStyle(
              fontSize: 17.0,
              fontWeight: FontWeight.bold,
              color: Colors.white,
              height: 2),
        ),
        icon: const Icon(Icons.info_outline, color: Colors.white),
        messageText: const SizedBox(),
        backgroundColor: const Color(0xB3000000),
        snackPosition: SnackPosition.BOTTOM);
  }
}
