import 'package:flutter/material.dart';
import 'package:flutter_clx_base/common/colours.dart';
import 'package:flutter_clx_base/common/gaps.dart';

class SelectTextItem extends StatelessWidget {
  const SelectTextItem({
    Key? key,
    required this.title,
    this.titleColor = text999,
    this.titleFontSize = 14.0,
    this.onTap,
    this.content = '',
    this.contentHint = '请选择',
    this.contentColor = text000,
    this.contentFontSize = 15.0,
    this.contentHintColor = textCd,
    this.minHeight = 50.0,
    this.hPadding = 20.0,
    this.hMargin = 0.0,
    this.isShowRightArrow = true,
    this.backgroundColor = white,
    this.selectAlignment = MainAxisAlignment.end,
    this.rightImage,
    this.rightImageWidth = 20.0,
    this.rightImageHeight = 20.0,
    this.leftImage,
    this.leftImageWidth,
    this.leftImageHeight,
  }) : super(key: key);

  final GestureTapCallback? onTap;
  final String title;
  final Color? titleColor;
  final double? titleFontSize;
  final String? content;
  final String contentHint;
  final Color? contentColor;
  final double? contentFontSize;
  final Color? contentHintColor;
  final double hPadding;
  final double hMargin;
  final double minHeight;
  final bool isShowRightArrow;
  final ImageProvider? rightImage;
  final double? rightImageWidth;
  final double? rightImageHeight;
  final ImageProvider? leftImage;
  final double? leftImageWidth;
  final double? leftImageHeight;
  final Color? backgroundColor;
  final MainAxisAlignment selectAlignment;

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: hPadding),
        margin: EdgeInsets.symmetric(horizontal: hMargin),
        constraints: BoxConstraints(minHeight: minHeight),
        color: backgroundColor,
        child: Row(
          children: <Widget>[
            // 左侧图标
            leftImage != null
                ? Container(
                    margin: const EdgeInsets.only(right: 8.0),
                    child: Image(
                      image: leftImage!,
                      width: leftImageWidth,
                      height: leftImageHeight,
                    ),
                  )
                : Container(),
            // 标题
            Text(
              title,
              style: TextStyle(color: titleColor, fontSize: titleFontSize),
            ),
            hGap16,
            Expanded(
              child: Row(
                mainAxisAlignment: selectAlignment,
                children: [
                  // 选中内容
                  Text(
                    content == null || content!.isEmpty
                        ? contentHint
                        : content!,
                    maxLines: 2,
                    overflow: TextOverflow.ellipsis,
                    style: TextStyle(
                      color: content == null || content!.isEmpty
                          ? contentHintColor
                          : contentColor,
                      fontSize: contentFontSize,
                    ),
                  ),
                  hGap5,
                  // 右侧图标
                  rightImage != null
                      ? Image(
                          image: rightImage!,
                          width: rightImageWidth,
                          height: rightImageHeight,
                        )
                      : isShowRightArrow
                          ? const Icon(
                              Icons.arrow_forward_ios,
                              color: Colors.grey,
                              size: 15,
                            )
                          : hGap15,
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
