import 'package:flutter/material.dart';
import 'package:keyboard_actions/keyboard_actions.dart';

import 'my_app_bar.dart';
import 'my_scroll_view.dart';

class MyScaffold extends StatelessWidget {
  final PreferredSizeWidget? appBar;
  final Color? backgroundColor;
  final Widget? body;
  final List<Widget>? children;
  final EdgeInsetsGeometry? padding;
  final String title;
  final Widget? bottomButton;
  final CrossAxisAlignment crossAxisAlignment;
  final KeyboardActionsConfig? keyboardConfig;

  const MyScaffold({
    Key? key,
    this.appBar,
    this.backgroundColor,
    this.children,
    this.title = "",
    this.padding,
    this.body,
    this.bottomButton,
    this.crossAxisAlignment = CrossAxisAlignment.start,
    this.keyboardConfig,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: appBar ?? MyPageAppBar(title: title),
      backgroundColor: backgroundColor ?? const Color(0xFFf2f3f3),
      body: body ??
          MyScrollView(
            children: children,
            padding: padding,
            bottomButton: bottomButton,
            crossAxisAlignment: crossAxisAlignment,
            keyboardConfig: keyboardConfig,
          ),
    );
  }
}
