import 'package:flutter/material.dart';

bool isNullOrEmpty(String? txt) {
  return txt == null || txt.isEmpty;
}

bool isMobile(String? mobile) {
  return !isNullOrEmpty(mobile) &&
      mobile!.length == 11 &&
      mobile.startsWith("1");
}

///判断文字是否为空
String txtIsNull(txt, {nullTxt = "-"}) {
  if (txt == null || txt == "") {
    return nullTxt;
  } else {
    return txt;
  }
}

String txtIsNullWithTitle(txt, title, {nullTxt = "-"}) {
  if (txt == null || txt == "") {
    return nullTxt;
  } else {
    return title + ": " + txt;
  }
}

///设置文字长度
String txtLength(String? txt, {int? length, nullTxt = ""}) {
  if (txt == null || txt == "") {
    return nullTxt;
  } else {
    if (length != null && txt.length > length) {
      return "${txt.substring(0, length)}...";
    }
    return txt;
  }
}



//时间去除.0
String? rightTime(String? time) {
  String? rightTime = time;
  if (time != null && time != "" && time.contains(".")) {
    rightTime = time.split(".")[0];
  }
  return rightTime;
}

//获取当前时间
String? getNowTime() {
  return rightTime(DateTime.now().toString());
}

//获取输入框内的信息
String getControllerString(TextEditingController controller) {
  return controller.value.text.toString().trim();
}

//获取输入框内的文字长度
int getControllerStringLength(TextEditingController controller) {
  return getControllerString(controller).length;
}

bool checkEasyPwd(String input,String phone) {
  //1：不能出现连续的字母或者数字
  var allMatchLength = input.length - 1; // 匹配全部
  var preMatchLength = input.length - 2; // 匹配N-1位
  RegExp allSameChar = new RegExp("([0-9a-zA-Z])\\1{$allMatchLength}"); // 匹配全为连续字符
  RegExp preSameChar = new RegExp("([0-9a-zA-Z])\\1{$preMatchLength}"); // 匹配n-1位位连续字符
  //2：不能出现顺子（123456或654321一类） 连续的数字
  // allSuccessiveNum 顺子
  // startCharSuccessiveNum  第一位字母  后面顺子
  // endCharSuccessiveNum    最后一位字母  前面顺子
  RegExp allSuccessiveNum = new RegExp("(?:0(?=1)|1(?=2)|2(?=3)|3(?=4)|4(?=5)|5(?=6)|6(?=7)|7(?=8)|8(?=9)|9(?=0)){$allMatchLength}\\d|(?:9(?=8)|8(?=7)|7(?=6)|6(?=5)|5(?=4)|4(?=3)|3(?=2)|2(?=1)|1(?=0)){$allMatchLength}\\d");
  RegExp startCharSuccessiveNum = new RegExp("[A-Za-z](?:0(?=1)|1(?=2)|2(?=3)|3(?=4)|4(?=5)|5(?=6)|6(?=7)|7(?=8)|8(?=9)){$preMatchLength}\\d|[A-Za-z](?:9(?=8)|8(?=7)|7(?=6)|6(?=5)|5(?=4)|4(?=3)|3(?=2)|2(?=1)|1(?=0)){$preMatchLength}\\d");
  RegExp endCharSuccessiveNum = new RegExp("((?:0(?=1)|1(?=2)|2(?=3)|3(?=4)|4(?=5)|5(?=6)|6(?=7)|7(?=8)|8(?=9)){$preMatchLength}\\d)[A-Za-z]|((?:9(?=8)|8(?=7)|7(?=6)|6(?=5)|5(?=4)|4(?=3)|3(?=2)|2(?=1)|1(?=0)){$preMatchLength}\\d)[A-Za-z]");

  // print('----- allSameChar: $allSameChar');
  // print('----- preSameChar: $preSameChar');
  // print('----- allSuccessiveNum: $allSuccessiveNum');
  // print('----- startCharSuccessiveNum: $startCharSuccessiveNum');
  // print('----- endCharSuccessiveNum: $endCharSuccessiveNum');
  // print('----- allSameChar: $input ${allSameChar.hasMatch(input)}');
  // print('----- preSameChar: $input ${preSameChar.hasMatch(input)}');
  // print('----- allSuccessiveNum: $input ${allSuccessiveNum.hasMatch(input)}');
  // print('----- startCharSuccessiveNum: $input ${startCharSuccessiveNum.hasMatch(input)}');
  // print('----- endCharSuccessiveNum: $input ${endCharSuccessiveNum.hasMatch(input)}');
  return allSameChar.hasMatch(input) ||
      preSameChar.hasMatch(input) ||
      allSuccessiveNum.hasMatch(input) ||
      startCharSuccessiveNum.hasMatch(input) ||
      endCharSuccessiveNum.hasMatch(input) ||
      phone.contains(input);
}
