
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';

class ImageUtils {

  static ImageProvider getNetworkImage(String name, {String format = 'png'}) {
    return NetworkImage(name);
  }

  static ImageProvider getAssetImage(String name, {String format = 'png'}) {
    return AssetImage(getImgPath(name, format: format));
  }

  static String getImgPath(String? name, {String format = 'png'}) {
    return 'assets/images/$name.$format';
  }

  static String getSVGPath(String name, {String format = 'svg'}) {
    return 'assets/images/$name.$format';
  }
}

