import 'package:flutter/material.dart';
import 'package:flutter_clx_base/utils/image_utils.dart';
import 'package:flutter_clx_base/widget/select_text_item.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({Key? key}) : super(key: key);

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        appBar: AppBar(
          title: const Text('Plugin example app'),
        ),
        body: Center(
          child: SelectTextItem(
            title: '类别',
            leftImage: ImageUtils.getAssetImage("img"),
            leftImageWidth: 20.0,
            leftImageHeight: 20.0,
            selectAlignment: MainAxisAlignment.start,
            isShowRightArrow: false,
          ),
        ),
      ),
    );
  }
}
