import 'dart:io';

import 'package:flutter/material.dart';

class MyPageAppBar extends StatelessWidget implements PreferredSizeWidget {
  final String? title;
  final Color? backgroundColor;
  final Color? foregroundColor;
  final bool showBack;
  final bool primary;
  final Function()? onBack;
  final List<Widget>? actions;
  final bool exitApp;
  final Widget? leading;
  final double? elevation;

  const MyPageAppBar({
    Key? key,
    this.title,
    this.backgroundColor,
    this.foregroundColor,
    this.showBack = true,
    this.primary = true,
    this.onBack,
    this.actions,
    this.exitApp = false,
    this.leading,
    this.elevation = 0,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return AppBar(
      key: key,
      centerTitle: true,
      title: Text(title ?? "", style: TextStyle(color: foregroundColor)),
      backgroundColor: backgroundColor,
      foregroundColor: foregroundColor,
      primary: primary,
      actions: actions,
      leading: leading,
      elevation: elevation,
    );
  }

  @override
  Size get preferredSize => const Size(double.infinity, 55.0);
}
