import 'package:flutter/material.dart';
import 'package:flutter_clx_base/common/extension.dart';
import 'package:fluttertoast/fluttertoast.dart';

class ToastUtil {
  static void showToast(String? txt,
      {ToastDuration toastDuration = ToastDuration.short}) {
    if (txt.isNullOrEmpty()) {
      txt = "信息异常";
    }
    Fluttertoast.showToast(
        msg: txt ?? "",
        toastLength: toastDuration == ToastDuration.long
            ? Toast.LENGTH_LONG
            : Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        // timeInSecForIos: 1,
        backgroundColor: Colors.grey,
        textColor: Colors.white,
        fontSize: 16.0);
  }
}

enum ToastDuration {
  /// Show Short toast for 1 sec
  short,

  /// Show Long toast for 5 sec
  long
}
