import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/base_list_widget.dart';
import 'package:flutter_clx_base_example/sample/list/detail/detail_view.dart';

import 'list1_logic.dart';

class List1Page extends StatelessWidget {
  List1Page({Key? key}) : super(key: key);

  final logic = Get.put(List1Logic());

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      title: 'list1',
      floatingActionButton: Row(
        children: [
          TextButton(
            onPressed: () {
              logic.controller.reload();
            },
            child: const Text("下拉刷新"),
          ),
          TextButton(
            onPressed: () {
              Get.to(DetailPage());
            },
            child: const Text("detail"),
          ),
        ],
      ),
      body: BaseListWidget(
        controller: logic.controller,
        requestData: (page, pageSize, success, error) async {
          await Future.delayed(const Duration(seconds: 1));
          if (page == 1) {
            success([
              {"key": "1", "value": "1"},
              {"key": "2", "value": '2'},
              {"key": "3", "value": '3'},
              {"key": "4", "value": '4'},
              {"key": "5", "value": '5'},
              {"key": "6", "value": '6'},
              {"key": "7", "value": '7'},
              {"key": "8", "value": '8'},
              {"key": "9", "value": '9'},
              {"key": "10", "value": '10'},
            ]);
          } else {
            success([
              {"key": "11", "value": "11"},
              {"key": "12", "value": '12'},
              {"key": "13", "value": '13'},
              {"key": "14", "value": '14'},
              {"key": "15", "value": '15'},
              {"key": "16", "value": '16'},
              {"key": "17", "value": '17'},
              {"key": "18", "value": '18'},
              {"key": "19", "value": '19'},
              {"key": "20", "value": '20'},
            ]);
          }
        },
        pageSize: 10,
        itemBuilder: (context, index, item) {
          return InkWell(
            onTap: () {
              item["value"] = "修改item ${index + 1}";
              logic.controller.notifySingleItem(index, item);
            },
            child: Container(
              height: 150.0,
              color: Colors.white,
              margin: const EdgeInsets.only(top: 10.0),
              alignment: Alignment.center,
              child: Text(item["value"]),
            ),
          );
        },
        // header: TaurusHeader(
        //   skyColor: themeData.colorScheme.primary,
        // ),
        // footer: ClassicFooter(
        //   dragText: 'Pull to load'.tr,
        //   armedText: 'Release ready'.tr,
        //   readyText: 'Loading...'.tr,
        //   processingText: 'Loading...'.tr,
        //   processedText: 'Succeeded'.tr,
        //   noMoreText: 'No more'.tr,
        //   failedText: 'Failed'.tr,
        //   messageText: 'Last updated at %T'.tr,
        // ),
        // startLoadWidget: Container(
        //   decoration: BoxDecoration(
        //     color: themeData.colorScheme.primary,
        //     borderRadius: BorderRadius.circular(10),
        //   ),
        //   alignment: Alignment.center,
        //   width: double.infinity,
        //   height: 300,
        //   // child: const RiveAnimation.asset(
        //   //   'assets/rive/highway-truck.riv',
        //   //   fit: BoxFit.cover,
        //   // ),
        // ),
      ),
    );
  }
}
