import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class MyPageAppBar extends StatelessWidget implements PreferredSizeWidget {
  final String? title;
  final Color? backgroundColor;
  final bool showBack;
  final bool primary;
  final Function()? onBack;
  final List<Widget>? actions;
  final bool exitApp;

  const MyPageAppBar({
    Key? key,
    this.title,
    this.backgroundColor,
    this.showBack = true,
    this.primary = true,
    this.onBack,
    this.actions,
    this.exitApp = false,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return AppBar(
      key: key,
      centerTitle: true,
      title: Text(title ?? ""),
      backgroundColor: backgroundColor,
      primary: primary,
      leading: showBack
          ? InkWell(
              onTap: onBack ??
                  () {
                    if (exitApp) {
                      SystemNavigator.pop();
                    } else {
                      Navigator.pop(context);
                    }
                  },
              child: const Icon(
                Icons.arrow_back_ios,
                color: Colors.white,
              ),
            )
          : null,
      actions: actions,
    );
  }

  @override
  Size get preferredSize => const Size(double.infinity, 55.0);
}
