import 'package:flutter/widgets.dart';

/// 扩展函数 Iterable
extension IterableExt<E> on Iterable<E> {
  // 获取元素
  E? getElement(int? index) {
    if (index == null || index >= length || index < 0) {
      return null;
    }
    int elementIndex = 0;
    for (E element in this) {
      if (index == elementIndex) return element;
      elementIndex++;
    }
    return null;
  }

  Iterable<T> mapIndexed<T>(T Function(E e, int i) f) {
    var i = 0;
    return map((e) => f(e, i++));
  }
}

/// 扩展函数 GlobalKey
extension GlobalKeyExt on GlobalKey {
  // 获取 widget size
  Size get getSize {
    final RenderBox? widget = currentContext?.findRenderObject() as RenderBox?;
    return widget?.size ?? Size.zero;
  }

  // 获取 widget offset
  Offset get getOffset {
    final RenderBox? widget = currentContext?.findRenderObject() as RenderBox?;
    return widget?.localToGlobal(Offset.zero) ?? Offset.zero;
  }
}

extension DateTimeExt on DateTime {}

extension StringExt on String? {
  bool isNullOrEmpty() {
    return this == null || this!.isEmpty;
  }
}

extension DoubleExt on num? {
  String format({nullText = "-"}) {
    double num;
    try {
      num = double.parse(toString());
    } catch (e) {
      print("转换异常:$e");
      return nullText;
    }
    if ((num.toString().length - num.toString().lastIndexOf(".") - 1) < 2) {
      //小数点后有几位小数
      return num.toStringAsFixed(2)
          .substring(0, num.toString().lastIndexOf(".") + 2 + 1)
          .toString();
    } else {
      return num.toString()
          .substring(0, num.toString().lastIndexOf(".") + 2 + 1)
          .toString();
    }
  }
}
