import 'package:flutter/material.dart';
import 'package:keyboard_actions/keyboard_actions.dart';

/// 本项目通用的布局（SingleChildScrollView）
/// 1.底部存在按钮
/// 2.底部没有按钮
class MyScrollView extends StatelessWidget {
  /// 注意：同时存在底部按钮与keyboardConfig配置时，为保证软键盘弹出高度正常。需要在`Scaffold`使用 `resizeToAvoidBottomInset: defaultTargetPlatform != TargetPlatform.iOS,`
  /// 除非Android与iOS平台均使用keyboard_actions
  const MyScrollView({
    Key? key,
    required this.children,
    this.padding,
    this.physics = const BouncingScrollPhysics(),
    this.crossAxisAlignment = CrossAxisAlignment.start,
    this.bottomButton,
    this.keyboardConfig,
    this.tapOutsideToDismiss = false,
    this.overScroll = 16.0,
    this.controller,
  }) : super(key: key);

  final List<Widget> children;
  final EdgeInsetsGeometry? padding;
  final ScrollPhysics physics;
  final CrossAxisAlignment crossAxisAlignment;
  final Widget? bottomButton;
  final KeyboardActionsConfig? keyboardConfig;
  final ScrollController? controller;

  /// 键盘外部按下将其关闭
  final bool tapOutsideToDismiss;

  /// 默认弹起位置在TextField的文字下面，可以添加此属性继续向上滑动一段距离。用来露出完整的TextField。
  final double overScroll;

  @override
  Widget build(BuildContext context) {
    Widget contents = SingleChildScrollView(
      padding: padding,
      physics: physics,
      controller: controller,
      child: SizedBox(
        width: double.infinity,
        child: Column(
          crossAxisAlignment: crossAxisAlignment,
          children: children,
        ),
      ),
    );
    // 软键盘处理 交互有问题，暂时去掉
    // if (keyboardConfig != null) {
    //   contents = KeyboardActions(
    //     isDialog: bottomButton != null,
    //     overscroll: overScroll,
    //     config: keyboardConfig!,
    //     tapOutsideBehavior: TapOutsideBehavior.opaqueDismiss,
    //     child: contents,
    //   );
    // }
    // 设置底部按钮
    if (bottomButton != null) {
      contents = Column(
        children: <Widget>[Expanded(child: contents), bottomButton!],
      );
    }
    return contents;
  }
}
