import 'dart:io';

import 'package:device_id_plugin/device_id_plugin.dart';
import 'package:device_info_plus/device_info_plus.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class DeviceUtils {

  //uuid
  static getDeviceSerial() async {
    DeviceIdPlugin deviceInfo = DeviceIdPlugin();
    return await deviceInfo.getDeviceId();
  }

  static getVersionName() async {
    PackageInfo packageInfo = await PackageInfo.fromPlatform();
    return packageInfo.version;
  }

  static getVersionCode() async {
    PackageInfo packageInfo = await PackageInfo.fromPlatform();
    return packageInfo.buildNumber.toInt();
  }

  static getDeviceModel() async {
    DeviceInfoPlugin deviceInfo = DeviceInfoPlugin();
    if (Platform.isAndroid) {
      AndroidDeviceInfo androidInfo = await deviceInfo.androidInfo;
      return androidInfo.model;
    } else {
      IosDeviceInfo iosInfo = await deviceInfo.iosInfo;
      return iosInfo.name;
    }
  }

}
