import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/utils/device_utils.dart';
import 'package:flutter_clx_base/widget/normal_dialog.dart';
import 'package:flutter_clx_base_example/sample/base_list_widget_test.dart';
import 'package:flutter_clx_base_example/sample/dio_widget_test.dart';

class Sample extends StatelessWidget {
  const Sample({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      title: 'Sample',
      children: [
        GFButton(
            fullWidthButton: true,
            onPressed: () => Get.to(const BaseListWidgetTest()),
            text: '列表'),
        GFButton(
            fullWidthButton: true,
            onPressed: () => Get.to(const DioWidgetTest()),
            text: 'dio'),
        GFButton(
            fullWidthButton: true,
            onPressed: () {
              Get.dialog(const NormalDialog(content: "通用dialog"));
            },
            text: 'NormalDialog'),
        GFButton(
            fullWidthButton: true,
            onPressed: () {
              // 1、manifest配置权限
              requestPermission(
                  permissionList: [Permission.camera], toSettingTip: "请开启相机权限");
            },
            text: '动态申请权限'),
        GFButton(
            fullWidthButton: true,
            onPressed: () async {
              var deviceModel = await DeviceUtils.getDeviceModel();
              var versionName = await DeviceUtils.getVersionName();
              var versionCode = await DeviceUtils.getVersionCode();
              var deviceSerial = await DeviceUtils.getDeviceSerial();
              debugPrint("===== deviceModel = $deviceModel "
                  " versionName = $versionName "
                  " versionCode = $versionCode "
                  " deviceSerial = $deviceSerial");
            },
            text: '获取设备信息'),
      ],
    );
  }
}
