import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/utils/image_utils.dart';

class StateLayout extends StatefulWidget {

  final StateType type;
  final String? img;
  final String? hintText;

  const StateLayout({
    Key? key,
    required this.type,
    this.img,
    this.hintText,
  }) : super(key: key);

  @override
  State<StateLayout> createState() => _StateLayoutState();
}

class _StateLayoutState extends State<StateLayout> {
  @override
  Widget build(BuildContext context) {
    return SizedBox(
      width: double.infinity,
      child:
          widget.type == StateType.loading ? _loadingWidget() : _otherWidget(),
    );
  }

  Widget _loadingWidget() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.center,
      children: const [
        CupertinoActivityIndicator(radius: 16.0),
      ],
    );
  }

  Widget _otherWidget() {
    switch (widget.type) {
      case StateType.network:
        // return _buildNormalView('icon_no_wifi', '无网络连接');
        return _buildNormalView(widget.img ?? '', '无网络连接');
      case StateType.loading:
        return Container();
      case StateType.empty:
        // return _buildNormalView('default_drawing_1', widget.hintText ?? '暂无数据');
        return _buildNormalView(widget.img ?? '', widget.hintText ?? '暂无数据');
      case StateType.error:
        // return _buildNormalView('icon_list_failure', '请求失败，请重试');
        return _buildNormalView(widget.img ?? '', '请求失败，请重试');
      case StateType.success:
        return Container();
    }
  }

  Widget _buildNormalView(String img, String hintText) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        Offstage(
          offstage: widget.img!.isEmpty,
          child: Opacity(
            opacity: 1,
            child: Container(
              height: 120.0,
              width: 120.0,
              decoration: BoxDecoration(
                image: DecorationImage(
                  image: ImageUtils.getAssetImage(img),
                ),
              ),
            ),
          ),
        ),
        const SizedBox(
          height: 16.0,
        ),
        Text(
          hintText,
          style: const TextStyle(fontSize: 14, color: Colors.grey),
        ),
      ],
    );
  }
}

enum StateType {
  /// 无网络
  network,

  /// 加载中
  loading,

  /// 空
  empty,

  ///异常
  error,

  ///成功
  success
}
