import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/widget/image_widget.dart';

class StateLayout extends StatefulWidget {

  final StateType type;
  final String? emptyImg;
  final String? hintText;

  const StateLayout({
    Key? key,
    required this.type,
    this.emptyImg,
    this.hintText,
  }) : super(key: key);

  @override
  State<StateLayout> createState() => _StateLayoutState();
}

class _StateLayoutState extends State<StateLayout> {
  @override
  Widget build(BuildContext context) {
    return SizedBox(
      width: double.infinity,
      child:
          widget.type == StateType.loading ? _loadingWidget() : _otherWidget(),
    );
  }

  Widget _loadingWidget() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.center,
      children: const [
        CupertinoActivityIndicator(radius: 16.0),
      ],
    );
  }

  Widget _otherWidget() {
    switch (widget.type) {
      case StateType.network:
        // return _buildNormalView('icon_no_wifi', '无网络连接');
        return _buildNormalView(widget.emptyImg ?? '', '无网络连接');
      case StateType.loading:
        return Container();
      case StateType.empty:
        // return _buildNormalView('default_drawing_1', widget.hintText ?? '暂无数据');
        return _buildNormalView(widget.emptyImg ?? '', widget.hintText ?? '暂无数据');
      case StateType.error:
        // return _buildNormalView('icon_list_failure', '请求失败，请重试');
        return _buildNormalView(widget.emptyImg ?? '', '请求失败，请重试');
      case StateType.success:
        return Container();
    }
  }

  Widget _buildNormalView(String img, String hintText) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.center,
      children: <Widget>[
        const SizedBox(height: 30.0),

        Offstage(
          offstage: _getShowImg(img),
          child: ImageWidget.loadAssetImage(
            img,
            width: 133.5*2,
            height: 95*2,
          ),
        ),
        Text(
          hintText,
          style: const TextStyle(
            color: Color(0xff86909C),
            fontSize: 14.0,
            fontWeight: FontWeight.normal,
          ),
        ),

        const SizedBox(height: 30.0),
      ],
    );
  }

  bool _getShowImg(String img) {
    if (img.isNotEmpty && widget.type == StateType.empty) {
      return false;
    }
    return true;
  }
}

enum StateType {
  /// 无网络
  network,

  /// 加载中
  loading,

  /// 空
  empty,

  ///异常
  error,

  ///成功
  success
}
