import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/normal_dialog.dart';
import 'package:flutter_clx_base_example/sample/base_list_widget_test.dart';
import 'package:flutter_clx_base_example/sample/dio_widget_test.dart';
import 'package:flutter_clx_base_example/sample/list/list1/list1_view.dart';
import 'package:flutter_clx_base_example/sample/scroll_view.dart';
import 'package:flutter_clx_base_example/sample/search_appbar.dart';

class Sample extends StatelessWidget {
  const Sample({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      title: 'Sample',
      children: [
        GFButton(
            fullWidthButton: true,
            onPressed: () => Get.to(const BaseListWidgetTest()),
            text: '列表'),
        GFButton(
            fullWidthButton: true,
            onPressed: () => Get.to(const DioWidgetTest()),
            text: 'dio'),
        GFButton(
            fullWidthButton: true,
            onPressed: () {
              Get.dialog(const NormalDialog(content: "通用dialog"));
            },
            text: 'NormalDialog'),
        GFButton(
            fullWidthButton: true,
            onPressed: () {
              // 1、manifest配置权限
              requestPermission(
                  permissionList: [Permission.camera], toSettingTip: "请开启相机权限");
            },
            text: '动态申请权限'),
        GFButton(
            fullWidthButton: true,
            onPressed: () => Get.to(const ScrollViewPage()),
            text: 'scrollView'),
        GFButton(
            fullWidthButton: true,
            onPressed: () {
              SnackBarUtil.show("11111");
            },
            text: 'SnackBar'),
        GFButton(
            fullWidthButton: true,
            onPressed: () {
              ToastUtil.showToast("11111");
            },
            text: 'toast'),
        GFButton(
            fullWidthButton: true,
            onPressed: () => Get.to(const SearchAppBarPage()),
            text: 'SearchAppBar'),
        GFButton(
            fullWidthButton: true,
            onPressed: () => Get.to(List1Page()),
            text: 'BaseListWidget多次reload无法应问题'),
      ],
    );
  }
}
