import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/normal_dialog.dart';
import 'package:flutter_clx_base_example/sample/base_list_widget_test.dart';
import 'package:flutter_clx_base_example/sample/dio_widget_test.dart';
import 'package:flutter_clx_base_example/sample/list/list1/list1_view.dart';
import 'package:flutter_clx_base_example/sample/scroll_view.dart';
import 'package:flutter_clx_base_example/sample/search_appbar.dart';

class Sample extends StatelessWidget {
  const Sample({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      title: 'Sample',
      children: [
        TextButton(
          onPressed: () => Get.to(const BaseListWidgetTest()),
          child: const Text('列表'),
        ),
        TextButton(
          onPressed: () => Get.to(const DioWidgetTest()),
          child: const Text('dio'),
        ),
        TextButton(
          onPressed: () {
            Get.dialog(const NormalDialog(content: "通用dialog"));
          },
          child: const Text('NormalDialog'),
        ),
        TextButton(
          onPressed: () {
            // 1、manifest配置权限
            requestPermission(
                permissionList: [Permission.camera], toSettingTip: "请开启相机权限");
          },
          child: const Text('动态申请权限'),
        ),
        TextButton(
          onPressed: () => Get.to(const ScrollViewPage()),
          child: const Text('scrollView'),
        ),
        TextButton(
          onPressed: () {
            SnackBarUtil.show("11111");
          },
          child: const Text('SnackBar'),
        ),
        TextButton(
          onPressed: () {
            ToastUtil.showToast("11111");
          },
          child: const Text('toast'),
        ),
        TextButton(
          onPressed: () => Get.to(const SearchAppBarPage()),
          child: const Text('SearchAppBar'),
        ),
        TextButton(
          onPressed: () => Get.to(List1Page()),
          child: const Text('BaseListWidget多次reload无法应问题'),
        ),
      ],
    );
  }
}
