import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/utils/image_utils.dart';
import 'package:octo_image/octo_image.dart';

class ImageWidget {
  static String domain = "";

  /// 加载网络图片widget
  static Widget loadNetImage(
    String? url, {
    String? domain,
    ImageTransformerType type = ImageTransformerType.rect,
    double? width,
    double? height,
    BoxFit fit = BoxFit.cover,
  }) {
    var domainUrl = domain ?? ImageWidget.domain;
    if (url != null && !url.startsWith("http")) {
      url = domainUrl + url;
    }

    return OctoImage(
      image: CachedNetworkImageProvider(url ?? ""),
      imageBuilder: type == ImageTransformerType.rect
          ? MyOctoImageTransformer.radiusAvatar()
          : MyOctoImageTransformer.circleAvatar(),
      errorBuilder: OctoError.icon(color: Colors.red),
      fit: fit,
      width: width,
      height: height,
    );
  }

  /// 加载网络图片widget
  static Widget loadAssetImage(
    String? image, {
    double? width,
    double? height,
    int? cacheWidth,
    int? cacheHeight,
    BoxFit? fit,
    String format = 'png',
    Color? color,
  }) {
    return Image.asset(
      ImageUtils.getImgPath(image, format: format),
      height: height,
      width: width,
      cacheWidth: cacheWidth,
      cacheHeight: cacheHeight,
      fit: fit,
      color: color,

      /// 忽略图片语义
      excludeFromSemantics: true,
    );
  }
}


class MyOctoImageTransformer {
  static OctoImageBuilder radiusAvatar() {
    return (context, child) => Center(
          child: AspectRatio(
            aspectRatio: 1.0,
            child: ClipRRect(
              borderRadius: BorderRadius.circular(5.0),
              child: child,
            ),
          ),
        );
  }

  static OctoImageBuilder circleAvatar() {
    return (context, child) => Center(
          child: AspectRatio(
            aspectRatio: 1.0,
            child: ClipOval(
              child: child,
            ),
          ),
        );
  }
}

enum ImageTransformerType {
  rect, // 矩形
  circle, // 圆形
}
