import 'package:feedback_complaint_plug/feedback_complaint_plug.dart';
import 'package:feedback_complaint_plug/feedback_complaint_plug_method_channel.dart';
import 'package:feedback_complaint_plug/feedback_complaint_plug_platform_interface.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:plugin_platform_interface/plugin_platform_interface.dart';

class MockFeedbackComplaintPlugPlatform
    with MockPlatformInterfaceMixin
    implements FeedbackComplaintPlugPlatform {

  @override
  Future<String?> getPlatformVersion() => Future.value('42');
}

void main() {
  final FeedbackComplaintPlugPlatform initialPlatform = FeedbackComplaintPlugPlatform.instance;

  test('$MethodChannelFeedbackComplaintPlug is the default instance', () {
    expect(initialPlatform, isInstanceOf<MethodChannelFeedbackComplaintPlug>());
  });

  test('getPlatformVersion', () async {
    FeedbackComplaintPlug feedbackComplaintPlugPlugin = FeedbackComplaintPlug();
    MockFeedbackComplaintPlugPlatform fakePlatform = MockFeedbackComplaintPlugPlatform();
    FeedbackComplaintPlugPlatform.instance = fakePlatform;

    expect(await feedbackComplaintPlugPlugin.getPlatformVersion(), '42');
  });
}
