import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'feedback_complaint_plug_method_channel.dart';

abstract class FeedbackComplaintPlugPlatform extends PlatformInterface {
  /// Constructs a FeedbackComplaintPlugPlatform.
  FeedbackComplaintPlugPlatform() : super(token: _token);

  static final Object _token = Object();

  static FeedbackComplaintPlugPlatform _instance = MethodChannelFeedbackComplaintPlug();

  /// The default instance of [FeedbackComplaintPlugPlatform] to use.
  ///
  /// Defaults to [MethodChannelFeedbackComplaintPlug].
  static FeedbackComplaintPlugPlatform get instance => _instance;

  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [FeedbackComplaintPlugPlatform] when
  /// they register themselves.
  static set instance(FeedbackComplaintPlugPlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  Future<String?> getPlatformVersion() {
    throw UnimplementedError('platformVersion() has not been implemented.');
  }
}
