import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';

import 'feedback_complaint_plug_platform_interface.dart';

/// An implementation of [FeedbackComplaintPlugPlatform] that uses method channels.
class MethodChannelFeedbackComplaintPlug extends FeedbackComplaintPlugPlatform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('feedback_complaint_plug');

  @override
  Future<String?> getPlatformVersion() async {
    final version = await methodChannel.invokeMethod<String>('getPlatformVersion');
    return version;
  }
}
