#import "DeviceIdPlugin.h"
#import <XYUUID/XYUUID.h>

@implementation DeviceIdPlugin
+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
  FlutterMethodChannel* channel = [FlutterMethodChannel
      methodChannelWithName:@"device_id_plugin"
            binaryMessenger:[registrar messenger]];
  DeviceIdPlugin* instance = [[DeviceIdPlugin alloc] init];
  [registrar addMethodCallDelegate:instance channel:channel];
}

- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
  if ([@"getDeviceId" isEqualToString:call.method]) {
    NSString *uuid = [XYUUID uuidForKeychain];
    result(uuid);
  } else {
    result(FlutterMethodNotImplemented);
  }
}

@end
