import 'package:flutter/widgets.dart';
import '../../utils/code_send_enum.dart';
import 'no_receive_sms_view.dart';
import 'no_receive_resend_sms_view.dart';
import 'no_receive_voice_view.dart';

/// 状态提示组件
class StatusTipsWidget extends StatelessWidget {
  const StatusTipsWidget({
    super.key,
    required this.codeSendType,
    required this.isAccessOutbound,
    required this.onSendSms,
    required this.onSendVoice,
    required this.onContactService,
    this.tipsStyle,
    this.reSendStyle,
    this.voiceSendStyle,
    this.contactStyle,
    this.isSmallWindow = false,
  });

  final CodeSendType codeSendType;
  final bool isAccessOutbound;
  final VoidCallback onSendSms;
  final VoidCallback onSendVoice;
  final VoidCallback onContactService;
  
  final TextStyle? tipsStyle;
  final TextStyle? reSendStyle;
  final TextStyle? voiceSendStyle;
  final TextStyle? contactStyle;
  final bool isSmallWindow;

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        /// 展示重新发送验证码按钮以及获取语音验证码按钮
        if (codeSendType == CodeSendType.notReceiveSmsCode)
          NoReceiveSmsView(
            isAccessOutCall: isAccessOutbound,
            tipsStyle: tipsStyle,
            reSendStyle: reSendStyle,
            voiceSendStyle: voiceSendStyle,
            isSmallWindow: isSmallWindow,
            sendSmsCode: onSendSms,
            sendVoiceCode: onSendVoice,
          ),

        /// 展示没有收到二次发送的验证码的提示
        if (codeSendType == CodeSendType.notReceiveResendSmsCode)
          NoReceiveResendSmsView(
            isAccessOutCall: isAccessOutbound,
            tipsStyle: tipsStyle,
            reSendStyle: reSendStyle,
            sendVoiceCode: onSendVoice,
          ),

        /// 展示没有收到首次发送的语音验证码的提示
        if (codeSendType == CodeSendType.notReceiveVoiceCode ||
            codeSendType == CodeSendType.notReceiveResendVoiceCode)
          NoReceiveVoiceView(
            isSmallWindow: isSmallWindow,
            tipsStyle: tipsStyle,
            reSendStyle: reSendStyle,
            contactStyle: contactStyle,
            sendVoiceCode: onSendVoice,
            contactService: onContactService,
            isShowContact: codeSendType == CodeSendType.notReceiveResendVoiceCode,
          ),
      ],
    );
  }
}
