import 'package:flutter/gestures.dart';
import 'package:flutter/widgets.dart';

class NoReceiveSmsView extends StatelessWidget {
  const NoReceiveSmsView({
    super.key,
    required this.isSmallWindow,
    required this.isAccessOutCall,
    this.reSendStyle,
    this.tipsStyle,
    this.voiceSendStyle,
    this.sendSmsCode,
    this.sendVoiceCode,
  });

  /// 是否接入外呼功能
  final bool isAccessOutCall;

  /// 重新获取文字样式
  final TextStyle? reSendStyle;

  /// 提示文字样式
  final TextStyle? tipsStyle;

  /// 语音发送文字样式
  final TextStyle? voiceSendStyle;

  /// 是否小窗模式
  final bool isSmallWindow;

  /// 发送短信验证码
  final GestureTapCallback? sendSmsCode;

  /// 发送语音验证码
  final GestureTapCallback? sendVoiceCode;

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 10),
      child: isSmallWindow
          ? Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                RichText(
                  text: TextSpan(
                    children: [
                      TextSpan(
                        text: '没有收到短信?',
                        style: tipsStyle,
                      ),
                      const WidgetSpan(child: SizedBox(width: 5)),
                      TextSpan(
                        text: '重新获取',
                        style: reSendStyle,
                        recognizer: TapGestureRecognizer()..onTap = sendSmsCode,
                      ),
                    ],
                  ),
                ),
                if (isAccessOutCall) ...[
                  const SizedBox(height: 4),
                  GestureDetector(
                    onTap: sendVoiceCode,
                    child: Text(
                      '获取语音验证码',
                      style: voiceSendStyle,
                    ),
                  ),
                ],
              ],
            )
          : Row(
              children: [
                RichText(
                  text: TextSpan(
                    children: [
                      TextSpan(
                        text: '没有收到短信?',
                        style: tipsStyle,
                      ),
                      const WidgetSpan(child: SizedBox(width: 5)),
                      TextSpan(
                        text: '重新获取',
                        style: reSendStyle,
                        recognizer: TapGestureRecognizer()..onTap = sendSmsCode,
                      ),
                    ],
                  ),
                ),
                if (isAccessOutCall) ...[
                  const Spacer(),
                  GestureDetector(
                    onTap: sendVoiceCode,
                    child: Text(
                      '获取语音验证码',
                      style: voiceSendStyle,
                    ),
                  ),
                ],
              ],
            ),
    );
  }
}
