import 'package:flutter/widgets.dart';

class LineCodeManageConfig {
  /// 外层容器
  Decoration? decoration;

  /// 外边距
  EdgeInsetsGeometry? margin;

  /// 内边距
  EdgeInsetsGeometry? padding;

  /// 输入框是否紧贴
  bool isCollapsed;

  /// 是否小窗口模式
  bool isSmallWindow;

  /// 提示文字
  String? hintText;

  /// 提示文字样式
  TextStyle? hintStyle;

  /// 输入框文字样式
  TextStyle? style;

  /// 倒计时文字样式
  TextStyle? countdownStyle;

  /// 倒计时文字样式
  TextStyle? codeSendStyle;

  /// 重新获取文字样式
  TextStyle? reSendStyle;

  /// 提示文字样式
  TextStyle? tipsStyle;

  /// 错误提示文字样式
  TextStyle? errorStyle;

  /// 语音发送文字样式
  TextStyle? voiceSendStyle;

  /// 联系客服文字样式
  TextStyle? contactStyle;

  LineCodeManageConfig({
    this.decoration = const BoxDecoration(
      borderRadius: BorderRadius.all(Radius.circular(6)),
      color: Color(0xffF7F8FA),
    ),
    this.margin = const EdgeInsets.symmetric(horizontal: 30),
    this.padding = const EdgeInsets.symmetric(horizontal: 30),
    this.isCollapsed = false,
    this.isSmallWindow = false,
    this.hintText,
    this.hintStyle = const TextStyle(
        color: Color(0xffC9CDD4), fontSize: 14, fontWeight: FontWeight.w400),
    this.style = const TextStyle(
        color: Color(0xff333C4C), fontSize: 15, fontWeight: FontWeight.w500),
    this.countdownStyle = const TextStyle(
      color: Color(0xff4F4535),
      fontSize: 14,
      fontWeight: FontWeight.w500,
    ),
    this.codeSendStyle = const TextStyle(
      color: Color(0xff4F4535),
      fontSize: 14,
      fontWeight: FontWeight.w500,
    ),
    this.reSendStyle = const TextStyle(
      color: Color(0xff4F4535),
      fontSize: 12,
      fontWeight: FontWeight.w600,
    ),
    this.tipsStyle = const TextStyle(
      color: Color(0xff86909C),
      fontSize: 12,
      fontWeight: FontWeight.w400,
    ),
    this.errorStyle = const TextStyle(
      color: Color(0xffFF4D4F),
      fontSize: 12,
      fontWeight: FontWeight.w400,
    ),
    this.voiceSendStyle = const TextStyle(
      color: Color(0xff4F4535),
      fontSize: 12,
      fontWeight: FontWeight.w600,
    ),
    this.contactStyle = const TextStyle(
      color: Color(0xff4F4535),
      fontSize: 12,
      fontWeight: FontWeight.w600,
    ),
  });
}
