enum CodeSendType {
  /// 未发送验证码
  none,

  /// 首次发送验证码
  firstSendSmsCode,

  /// 首次发送短信验证码，超时未收到，需要展示重新发动短信验证码按钮以及获取语音验证码按钮
  notReceiveSmsCode,

  /// 重新发送验短息证码
  resendSmsCode,

  /// 重新发送短信验证码，超时未收到，只能展示获取语音验证码按钮
  notReceiveResendSmsCode,

  /// 首次发送语音验证码
  firstSendVoiceCode,

  /// 首次发送语音验证码，超时未收到，只展示获取语音验证码按钮
  notReceiveVoiceCode,

  /// 重新发送语音证码
  resendVoiceCode,

  /// 重新发送语音验证码，超时未收到，需要展示获取语音验证码按钮以及联系人工服务按钮
  notReceiveResendVoiceCode,
}

extension CodeSendTypeExtension on CodeSendType {
  /// 是否发送过验证码
  bool get isUnSend => this == CodeSendType.none;

  /// 是否已发送过验证码
  bool get isSend =>
      this == CodeSendType.firstSendSmsCode ||
      this == CodeSendType.firstSendVoiceCode ||
      this == CodeSendType.resendSmsCode ||
      this == CodeSendType.resendVoiceCode;

  /// 是否短信验证码
  bool get isSms =>
      this == CodeSendType.firstSendSmsCode ||
      this == CodeSendType.resendSmsCode;

  /// 是否语音验证码
  bool get isVoice =>
      this == CodeSendType.firstSendVoiceCode ||
      this == CodeSendType.resendVoiceCode;

  /// 是否首次发送
  bool get isFirst =>
      this == CodeSendType.firstSendSmsCode ||
      this == CodeSendType.firstSendVoiceCode;

  /// 是否第二次发送
  bool get isSecond =>
      this == CodeSendType.resendSmsCode ||
      this == CodeSendType.resendVoiceCode;

  /// 是否展示联系客服按钮
  bool get isShowContact => this == CodeSendType.notReceiveResendVoiceCode;
}

extension CodeSendTypeCode on CodeSendType {
  int get code {
    switch (this) {
      case CodeSendType.none:
        return 0;
      case CodeSendType.firstSendSmsCode:
        return 1;
      case CodeSendType.notReceiveSmsCode:
        return 2;
      case CodeSendType.resendSmsCode:
        return 3;
      case CodeSendType.notReceiveResendSmsCode:
        return 4;
      case CodeSendType.firstSendVoiceCode:
        return 5;
      case CodeSendType.notReceiveVoiceCode:
        return 6;
      case CodeSendType.resendVoiceCode:
        return 7;
      case CodeSendType.notReceiveResendVoiceCode:
        return 8;
    }
  }
}
