import '../utils/code_send_enum.dart';

/// 验证码状态机
class VerificationStateMachine {
  final bool isAccessOutbound;

  VerificationStateMachine({required this.isAccessOutbound});

  /// 根据当前状态和触发动作计算下一个状态
  CodeSendType nextState(CodeSendType currentState, {bool isSmsSend = true}) {
    switch (currentState) {
      case CodeSendType.none:
        return CodeSendType.firstSendSmsCode;
        
      case CodeSendType.firstSendSmsCode:
        return CodeSendType.notReceiveSmsCode;
        
      case CodeSendType.notReceiveSmsCode:
        return isSmsSend 
            ? CodeSendType.resendSmsCode 
            : CodeSendType.firstSendVoiceCode;
            
      case CodeSendType.resendSmsCode:
        return isAccessOutbound 
            ? CodeSendType.notReceiveResendSmsCode 
            : CodeSendType.resendSmsCode; // 如果没有外呼，可能保持原状或进入其他逻辑，这里保持原逻辑
            
      case CodeSendType.notReceiveResendSmsCode:
        return CodeSendType.firstSendVoiceCode;
        
      case CodeSendType.firstSendVoiceCode:
        return CodeSendType.notReceiveVoiceCode;
        
      case CodeSendType.notReceiveVoiceCode:
        return CodeSendType.resendVoiceCode;
        
      case CodeSendType.resendVoiceCode:
        return CodeSendType.notReceiveResendVoiceCode;
        
      case CodeSendType.notReceiveResendVoiceCode:
        return CodeSendType.resendVoiceCode;
        
      default:
        return CodeSendType.notReceiveResendVoiceCode;
    }
  }
}
