# CLX Verification Code

一个功能强大、高度可定制的 Flutter 验证码业务组件。支持短信验证码、语音验证码、倒计时管理、自动状态流转（如短信未收到自动提示语音验证码）以及完善的错误处理。

## 🚀 快速开始

### 1. 实现服务接口

首先，你需要实现 `IVerificationService` 接口，对接你的后端 API。

```dart
import 'package:clx_verification_code/clx_verification_code.dart';

class MyVerificationService implements IVerificationService {
  @override
  Future<bool> sendSmsCode() async {
    // TODO: 调用发送短信 API
    // return await api.sendSms();
    return true;
  }

  @override
  Future<bool> sendVoiceCode() async {
    // TODO: 调用发送语音 API
    return true;
  }

  @override
  Future<String?> verifyCode(String code) async {
    // TODO: 调用校验 API
    // return null; // 校验通过
    return "验证码错误"; // 返回错误信息
  }

  @override
  Future<void> contactCustomerService() async {
    // TODO: 处理联系客服逻辑
  }
}
```

### 2. 使用组件

在你的页面中使用 `CLXLineCodeManageView` 或 `CLXPageCodeManageView`。

```dart
import 'package:flutter/material.dart';
import 'package:clx_verification_code/clx_verification_code.dart';

class LoginPage extends StatefulWidget {
  @override
  _LoginPageState createState() => _LoginPageState();
}

class _LoginPageState extends State<LoginPage> {
  late VerificationCodeViewModel _viewModel;

  @override
  void initState() {
    super.initState();
    // 初始化 ViewModel
    _viewModel = VerificationCodeViewModel(
      service: MyVerificationService(),
      maxLength: 6,
      onShowToast: (msg) {
        // 处理 Toast 提示
        ScaffoldMessenger.of(context).showSnackBar(SnackBar(content: Text(msg)));
      },
    );
  }

  @override
  void dispose() {
    _viewModel.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: Text("验证码示例")),
      body: Padding(
        padding: const EdgeInsets.all(20.0),
        child: Column(
          children: [
            // 使用行内样式组件
            CLXLineCodeManageView(
              viewModel: _viewModel,
              config: LineCodeManageConfig(
                hintText: "请输入验证码",
                // 更多样式配置...
              ),
            ),
            SizedBox(height: 20),
            ElevatedButton(
              onPressed: () {
                // 可以在这里获取输入内容
                print("输入内容: ${_viewModel.codeInputCtrl.text}");
              },
              child: Text("提交"),
            )
          ],
        ),
      ),
    );
  }
}
```

## 📚 API 文档

### VerificationCodeViewModel

| 参数 | 类型 | 说明 | 默认值 |
| --- | --- | --- | --- |
| `service` | `IVerificationService` | **必传**。业务逻辑实现接口。 | - |
| `maxLength` | `int` | 验证码长度。 | `6` |
| `isFirstResponsed` | `bool` | 是否自动获取焦点。 | `false` |
| `isAccessOutbound` | `bool` | 是否开启语音验证码/外呼功能。 | `true` |
| `onShowToast` | `Function(String)` | Toast 提示回调。 | `null` |

### IVerificationService

| 方法 | 返回值 | 说明 |
| --- | --- | --- |
| `sendSmsCode()` | `Future<bool>` | 发送短信验证码。返回 `true` 表示成功。 |
| `sendVoiceCode()` | `Future<bool>` | 发送语音验证码。返回 `true` 表示成功。 |
| `verifyCode(String code)` | `Future<String?>` | 校验验证码。返回 `null` 表示通过，否则返回错误文案。 |
| `contactCustomerService()` | `Future<void>` | 联系客服的回调。 |

### 组件视图

#### CLXLineCodeManageView
适用于表单行内的验证码输入（通常是左侧输入框，右侧发送按钮）。

| 参数 | 类型 | 说明 |
| --- | --- | --- |
| `viewModel` | `VerificationCodeViewModel` | ViewModel 实例。 |
| `config` | `LineCodeManageConfig` | 样式配置对象。 |
| `disabled` | `bool` | 是否禁用输入。 |

#### CLXPageCodeManageView
适用于独立的验证码输入页面（通常是分格输入框）。

| 参数 | 类型 | 说明 |
| --- | --- | --- |
| `viewModel` | `VerificationCodeViewModel` | ViewModel 实例。 |
| `config` | `PageCodeManageConfig` | 样式配置对象。 |

### 配置对象

#### LineCodeManageConfig / PageCodeManageConfig

支持配置 `margin`, `padding`, `decoration`, `hintText`, `hintStyle`, `style`, `countdownStyle`, `errorStyle` 等几乎所有视觉元素。详情请参考源码注释。
