import 'package:flutter/cupertino.dart';
import 'package:flutter/gestures.dart';
import 'package:flutter/widgets.dart';

class NoReceiveVoiceView extends StatelessWidget {
  const NoReceiveVoiceView({
    super.key,
    required this.isShowContact,
    required this.isSmallWindow,
    this.reSendStyle,
    this.tipsStyle,
    this.contactStyle,
    this.contactService,
    this.sendVoiceCode,
  });

  /// 重新获取文字样式
  final TextStyle? reSendStyle;

  /// 提示文字样式
  final TextStyle? tipsStyle;

  /// 联系客服文字样式
  final TextStyle? contactStyle;

  /// 是否小窗模式
  final bool isSmallWindow;

  /// 是否显示联系客服
  final bool isShowContact;

  /// 联系客服
  final GestureTapCallback? contactService;

  /// 发送语音验证码
  final GestureTapCallback? sendVoiceCode;

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 10),
      child: isSmallWindow
          ? Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                RichText(
                  text: TextSpan(
                    children: [
                      TextSpan(
                        text: '没有收到语音?',
                        style: tipsStyle,
                      ),
                      const WidgetSpan(child: SizedBox(width: 5)),
                      TextSpan(
                        text: '重新获取',
                        style: reSendStyle,
                        recognizer: TapGestureRecognizer()
                          ..onTap = sendVoiceCode,
                      ),
                    ],
                  ),
                ),
                if (isShowContact) ...[
                  const SizedBox(height: 4),
                  GestureDetector(
                    onTap: contactService,
                    child: Text(
                      '联系人工服务',
                      style: contactStyle,
                    ),
                  ),
                ],
              ],
            )
          : Row(
              children: [
                Expanded(
                  child: RichText(
                    text: TextSpan(
                      children: [
                        TextSpan(
                          text: '没有收到语音?',
                          style: tipsStyle,
                        ),
                        const WidgetSpan(child: SizedBox(width: 5)),
                        TextSpan(
                          text: '重新获取',
                          style: reSendStyle,
                          recognizer: TapGestureRecognizer()
                            ..onTap = sendVoiceCode,
                        ),
                      ],
                    ),
                  ),
                ),
                if (isShowContact) ...[
                  const SizedBox(width: 10),
                  GestureDetector(
                    onTap: contactService,
                    child: Text(
                      '联系人工服务',
                      style: contactStyle,
                    ),
                  ),
                ],
              ],
            ),
    );
  }
}
