import 'package:flutter/gestures.dart';
import 'package:flutter/widgets.dart';

class NoReceiveResendSmsView extends StatelessWidget {
  const NoReceiveResendSmsView({
    super.key,
    required this.isAccessOutCall,
    this.reSendStyle,
    this.tipsStyle,
    this.sendVoiceCode,
  });

  /// 是否接入外呼功能
  final bool isAccessOutCall;

  /// 重新获取文字样式
  final TextStyle? reSendStyle;

  /// 提示文字样式
  final TextStyle? tipsStyle;

  /// 发送语音验证码
  final GestureTapCallback? sendVoiceCode;

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 10),
      child: RichText(
        text: TextSpan(
          children: [
            TextSpan(
              text: '没有收到短信?',
              style: tipsStyle,
            ),
            const WidgetSpan(child: SizedBox(width: 5)),
            if (isAccessOutCall)
              TextSpan(
                text: '获取语音验证码',
                style: reSendStyle,
                recognizer: TapGestureRecognizer()..onTap = sendVoiceCode,
              ),
          ],
        ),
      ),
    );
  }
}
