import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

import 'code_input_paint.dart';

class CodeInputView extends StatelessWidget {
  const CodeInputView({
    super.key,
    required this.controller,
    required this.focusNode,
    this.obscureText = false,
    this.inputRectBg = const Color(0xffF2F3F5),
    this.maxLength = 6,
    this.runSpance = 8,
    this.radius = 8,
  });

  final TextEditingController controller;
  final FocusNode focusNode;
  final bool obscureText; //是否隐藏输入内容
  final Color inputRectBg; //输入框背景色
  final int maxLength; //输入长度
  final double runSpance; //输入框间距
  final double radius; //输入框圆角

  @override
  Widget build(BuildContext context) {
    final inputHeight = (MediaQuery.of(context).size.width -
            (40 + runSpance * (maxLength - 1))) /
        maxLength;
    return CustomPaint(
      foregroundPainter: CodeInputPaint(
        text: obscureText
            ? controller.text.replaceAll(RegExp(r'\d'), '*')
            : controller.text,
        bgColor: inputRectBg,
        runSpance: runSpance,
        length: maxLength,
        radius: radius,
      ),
      child: TextField(
        controller: controller,
        maxLength: maxLength,
        keyboardType: TextInputType.number,
        inputFormatters: [FilteringTextInputFormatter.digitsOnly],
        showCursor: false,
        enableSuggestions: false,
        focusNode: focusNode,
        enableInteractiveSelection: false,
        style: const TextStyle(color: Colors.white),
        decoration: InputDecoration(
          contentPadding: EdgeInsets.zero,
          isCollapsed: true,
          suffix: SizedBox(height: inputHeight),
          border: InputBorder.none,
          counterText: '',
        ),
      ),
    );
  }
}
