import 'package:flutter/material.dart';

class CodeInputPaint extends CustomPainter {
  const CodeInputPaint({
    this.text,
    this.bgColor = const Color(0xffF2F3F5),
    this.runSpance = 8,
    this.length = 6,
    this.radius = 8,
  });

  final String? text;

  //背景颜色
  final Color bgColor;
  //间隔
  final double runSpance;
  // 输入框个数
  final int length;
  // 圆角半径
  final double radius;

  @override
  void paint(Canvas canvas, Size size) {
    var sizeWidth = (size.width - runSpance * (length - 1)) / length;

    // 绘制方框
    for (var i = 0; i < length; i++) {
      var rect = _Rect(
        x: sizeWidth * i + runSpance * i,
        y: 0,
        width: sizeWidth,
        height: sizeWidth,
      );
      _drawCircularRect(canvas, rect);
    }

    // 绘制文字
    if (text != null) {
      for (var i = 0; i < text!.length; i++) {
        var textPainter = TextPainter(
          text: TextSpan(
            text: text![i],
            style: TextStyle(
              color: Colors.red,
              fontSize: sizeWidth * 0.6,
            ),
          ),
          textDirection: TextDirection.ltr,
        );
        textPainter.layout();
        textPainter.paint(
          canvas,
          Offset(
              sizeWidth * i +
                  runSpance * i +
                  sizeWidth / 2 -
                  textPainter.width / 2,
              sizeWidth / 2 - textPainter.height / 2),
        );
      }
    }
  }

  void _drawCircularRect(Canvas canvas, _Rect rect) {
    canvas.drawRRect(
      RRect.fromRectAndRadius(
        Rect.fromLTWH(rect.x, rect.y, rect.width, rect.height),
        Radius.circular(radius),
      ),
      Paint()
        ..color = bgColor
        ..style = PaintingStyle.fill,
    );
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) {
    return !(oldDelegate is CodeInputPaint && oldDelegate.text == text);
  }
}

class _Rect {
  final double x;
  final double y;
  final double width;
  final double height;

  const _Rect({
    required this.x,
    required this.y,
    required this.width,
    required this.height,
  });
}
