import 'package:flutter/widgets.dart';

import '../clx_verification_code.dart';
import '../widgets/tips_widget/status_tips_widget.dart';

class CLXPageCodeManageView extends StatelessWidget {
  const CLXPageCodeManageView({
    super.key,
    required this.viewModel,
    required this.config,
  });

  /// 页面状态变化处理控制器
  final VerificationCodeViewModel viewModel;

  /// 是否隐藏输入内容
  final PageCodeManageConfig config;

  @override
  Widget build(BuildContext context) {
    return AnimatedBuilder(
      animation: viewModel,
      builder: (context, child) {
        return Container(
          margin: config.margin,
          padding: config.padding,
          decoration: config.decoration,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              CodeInputView(
                controller: viewModel.codeInputCtrl,
                focusNode: viewModel.codeInputFocus,
                obscureText: config.obscureText,
                maxLength: viewModel.maxLength,
                inputRectBg: config.inputRectBg,
                runSpance: config.runSpance,
                radius: config.radius,
              ),
              Visibility(
                visible: viewModel.verifyCodeError.isNotEmpty,
                child: Column(
                  children: [
                    const SizedBox(height: 5),
                    Text(
                      viewModel.verifyCodeError,
                      style: config.errorStyle,
                    ),
                  ],
                ),
              ),
              Visibility(
                visible: viewModel.isShowTip,
                child: StatusTipsWidget(
                  codeSendType: viewModel.codeSendType,
                  isAccessOutbound: viewModel.isAccessOutbound,
                  onSendSms: viewModel.sendSmsCode,
                  onSendVoice: viewModel.sendVoiceCode,
                  onContactService: viewModel.contactService,
                  tipsStyle: config.tipsStyle,
                  reSendStyle: config.reSendStyle,
                  voiceSendStyle: config.voiceSendStyle,
                  contactStyle: config.contactStyle,
                  isSmallWindow: false,
                ),
              ),
            ],
          ),
        );
      },
    );
  }
}
